#!/usr/bin/perl

use strict;
use FileHandle;
use Compress::Raw::Zlib;

MAIN: {
    if ( $#ARGV < 0) {
        print "usage: idm2txt.pl (sourcedir)\n";
        die "\n";
    }

    my $srcdir = $ARGV[0];
    $srcdir =~ s/^(.+?)\/?$/$1\//;

    my $content_filename = $srcdir.'CONTENT.tda';
    my $content_index_filename = $srcdir.'CONTENT.tda.tdz';
    my $content_handle = new FileHandle;
    if (!$content_handle->open("$content_filename", 'r')) {
        die "$content_filename: $^E\n";
    }
    binmode $content_handle;
    my $content_index_handle = new FileHandle;
    if (!$content_index_handle->open("$content_index_filename", 'r')) {
        die "Failed to open the file: $content_index_filename\n";
    }
    binmode $content_index_handle;

    for (;;) {
        my $size;
        my $tmp;
	my $zipped_contents;
	my $contents;
	my $content;

        if (read($content_index_handle, $tmp, 8) != 8) {
            last;
        }
        ($size) = unpack("x4V", $tmp);
        if (read($content_handle, $zipped_contents, $size) != $size) {
            die "File reading error: $content_filename\n";
        }
        my ($inflater, $status) = new Compress::Raw::Zlib::Inflate();
        if ($status != Z_OK) {
            die "Failed to initialize inflater\n";
        }
        $inflater->inflate($zipped_contents, $contents);
        if ($status != Z_OK && $status != Z_STREAM_END) {
            die "Failed to inflate\n";
        }
        foreach $content (split(/\0+/, $contents)) {
	    print $content, "\n";
	}
    }
}
