#!/usr/bin/perl

use Image::Magick;

our $font;
our $pointsize;
our %symbol_table;

use vars qw($gaiji_debug);

require './ldoce5-fpw.conf';
require './gaijitbl.pl';

my $debug = 1;

if($debug){
    mkdir "bitmap", 0755 if !(-d "bitmap");
}
mkdir "gaiji", 0755 if !(-d "gaiji");
open(FCOUT, '>fullchar.txt') || die "fullchar.txt: $^E\n";
open(HCOUT, '>halfchar.txt') || die "halrchar.txt: $^E\n";

my %fc_table;
my %hc_table;
foreach my $code (keys %symbol_table) {
    my $tag = $symbol_table{$code};
	my $case;
	my $base = "";
	my $image;

	if ($tag !~ /\{(..)-(u-(.+))\}/) {
		next;
	}
	$case = $1;
	$base = $2;
	$code = $3;
	if(defined $fc_table{$base} || defined $hc_table{$base}){
		next;
	}

	my $text = pack('H*', $code);
	$| = 1;
	printf("%-70s\r", "[$code]");
	$| = 0;
	if ($case eq 'fc') {
		$image = Image::Magick->new(size=>"16x16", pointsize=>$pointsize, font=>$font);
	}
	elsif ($case eq 'hc') {
		$image = Image::Magick->new(size=>"8x16", pointsize=>$pointsize, font=>$font);
	}
	$image->Read('xc:white');
	$image->Annotate(text => $text, x => 0, y => 0,
					 fill => 'black', antialias => false,
					 style => Normal, gravity => Center,
					 scale => 1.0,0.1,
					 encoding => 'UTF-8');
	$image->Write("bitmap/$base.bmp") if $debug;
	$image->Write("gaiji/$base.xbm");
	if ($case eq 'fc') {
		print FCOUT "$base gaiji/$base.xbm\n";
		$fc_table{$base} = 1;
	}
	elsif ($case eq 'hc') {
		print HCOUT "$base gaiji/$base.xbm\n";
		$hc_table{$base} = 1;
	}
}
1;
