#!/usr/bin/perl

$halfchar = "work/halfchar";
$fullchar = "work/fullchar";
$mapfile  = "LDOCE5.map";

open HCHAR, "<$halfchar" || die "$halfchar: $^E\n";
open FCHAR, "<$fullchar" || die "$fullchar: $^E\n";
open EBWIN, ">$mapfile" || die "$mapfile: $^E\n";

while(<HCHAR>){
    chomp;
    if($_ =~ /^u-([0-9a-fA-F]{4,6})\s+([0-9a-fA-F]{4,})/){
	$utf8 = hex($1);
	$utf16 = (($utf8>>4)& 0xf000) + (($utf8>>2)& 0x7c0) + ($utf8 & 0x3f);
	printf (EBWIN "h%s\tu%04x\r\n", $2, $utf16);
    }
}

print EBWIN "\n";

while(<FCHAR>){
    chomp;
    if($_ =~ /^u-([0-9a-fA-F]{4,6})\s+([0-9a-fA-F]{4,})/){
	$utf8 = hex($1);
	$utf16 = (($utf8>>4)& 0xf000) + (($utf8>>2)& 0x7c0) + ($utf8 & 0x3f);
	printf (EBWIN "z%s\tu%04x\r\n", $2, $utf16);
    }
}
